#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
import commands
import os
import re
import time
import tv2avi
import recdblist
def ts2x264(pin, pout, opts):#sizeは"HD"か"SD"
    """
    pinで指定されたファイルをpoutにx264でエンコードして書き出す
    """
    dualpass = 0
    isvfr=0
    is24fps=0
    islight=0
    size="Tall"
    quality=5
    if re.search("2", opts):
        dualpass = 1
    if re.search("H", opts):
        size = "HD"
    if re.search("S", opts):
        size = "SD"
        quality=quality-2
    if re.search("F", opts):
        size = "FHD"
    if re.search("L", opts):
        size = "Short"
        quality=quality-2
    if re.search("G", opts):
        size = "LowHD"
    if re.search("v", opts):
        is24fps=1
    if re.search("a", opts):
        is24fps=1
        quality=quality+2
    if re.search("l",opts):
        quality=quality-2
    if re.search("h",opts):
        quality=quality+2
    if re.search("d",opts):
        encode_ffmpeg(pin, pout, size, dualpass ,is24fps , quality)
    elif re.search("5",opts):
        encode_ffmpeg(pin, pout, size, dualpass ,is24fps , quality)
    else:
        encode(pin, pout,size,dualpass,is24fps,quality)
def encode(pin,pout,size,is2pass,is24fps,quality):
    encvf=""
    txt=""
    encvf="-vf yadif=0,pp=l5"
    harddup=",hqdn3d=2:1:2,unsharp=l3x3:0.75:c3x3:0.75,harddup"
    ofps="-ofps 30000/1001"
    fps="-fps 30000/1001"
    bm=1
    scale=""
    bnum=2000
    if size == "HD":
        encvf = encvf + ",scale=1280:720::0:3"+harddup
        bitrate = "bitrate=" + str(tv2avi.Bitrate_HD*bm)
        bnum=tv2avi.Bitrate_HD*bm
        crf="crf=20"
    elif size == "SD":
        encvf = encvf + ",scale=720:480::0:3"+harddup
        bitrate = "bitrate=" + str(tv2avi.Bitrate_SD*bm)
        bnum=tv2avi.Bitrate_SD*bm
        crf="crf=20"
    elif size == "FHD":
        encvf = encvf + ",scale=1920:1080::0:3"+harddup
        bitrate = "bitrate=" + str(tv2avi.Bitrate_FHD*bm)
        bnum=tv2avi.Bitrate_FHD*bm
        crf="crf=22"
    elif size == "Short":
        encvf = encvf +harddup
        bitrate = "bitrate=" + str(tv2avi.Bitrate_Short*bm)
        bnum=tv2avi.Bitrate_Short*bm
        crf="crf=20"
    elif size == "LowHD":
        encvf = encvf + ",scale=1280:720::0:3"+harddup
        bitrate = "bitrate=" + str(tv2avi.Bitrate_LowHD*bm)
        bnum=tv2avi.Bitrate_LowHD*bm
        crf="crf=22"
    else:
        encvf = encvf + ",scale=1280:720::0:3"+harddup
        bitrate = "bitrate=" + str(tv2avi.Bitrate_HD*bm)
        bnum=tv2avi.Bitrate_HD*bm
        crf="crf=22"
    x264enc=""
    x264enc1=""
    x264enc2=""

    if quality<3:
        x264enc=":me=dia:partitions=none:frameref=1:subq=2:scenecut=0:trellis=0"
        x264enc1=x264enc
        x264enc2=x264enc1
    elif quality<5:
        x264enc=":me=dia:partitions=i8x8,i4x4:frameref=1:subq=4:trellis=0"
        x264enc1=x264enc
        x264enc2=x264enc1
    elif quality<7:
        x264enc=":8x8dct:bframes=1"
        x264enc1=x264enc
        x264enc2=x264enc1
    elif quality<9:
        x264enc=":direct_pred=auto:frameref=5:subq=6:8x8dct:bframes=3:trellis=1"
        x264enc1=x264enc
        x264enc2=x264enc1
    elif quality<11:
        x264enc=":frameref=5:subq=7:trellis=2:partitions=all:8x8dct:direct_pred=auto:me=umh:bframes=3"
        x264enc1=x264enc
        x264enc2=x264enc1
    crf=""
    if is24fps==1:
        ofps="-ofps 24000/1001"
        fps="-fps 30000/1001"
        encvf="-vf pullup,softskip"
        harddup=",pp=l5,unsharp=l3x3:0.75:c3x3:0.75,hqdn3d=2:1:2,harddup"
        bm=1
        if quality<3:
            vbv=":vbv_maxrate="+str(bnum*2)+":vbv_bufsize="+str(bnum*4)
            x264enc=":me=dia:aq-strength=0.6:deblock=1,1:psy-rd=0.4:partitions=none:frameref=1:subq=2:scenecut=0:trellis=0"
            x264enc1=x264enc+vbv
            x264enc2=x264enc1
        elif quality<5:
            vbv=":vbv_maxrate="+str(bnum*2)+":vbv_bufsize="+str(bnum*4)
            x264enc=":me=dia:aq-strength=0.6:deblock=1,1:psy-rd=0.4:partitions=i8x8,i4x4:frameref=1:subq=4:trellis=0"
            x264enc1=x264enc+vbv
            x264enc2=x264enc1
        elif quality<7:
            vbv=":vbv_maxrate="+str(bnum*2)+":vbv_bufsize="+str(bnum*4)
            x264enc=":aq-strength=0.6:8x8dct:deblock=1,1:psy-rd=0.4:bframes=1"
            x264enc1=x264enc+vbv
            x264enc2=x264enc1
        elif quality<9:
            vbv=":vbv_maxrate="+str(bnum*2)+":vbv_bufsize="+str(bnum*4)
            x264enc=":direct_pred=auto:aq-strength=0.6:deblock=1,1:psy-rd=0.4:8x8dct:frameref=5:subq=6:bframes=3:trellis=1"
            x264enc1=x264enc+vbv
            x264enc2=x264enc1
        elif quality<11:
            vbv=":vbv_maxrate="+str(bnum*2)+":vbv_bufsize="+str(bnum*4)
            x264enc=":frameref=5:subme=8:subq=7:trellis=2:aq-strength=0.6:deblock=1,1:psy-rd=0.4:partitions=all:8x8dct:direct_pred=auto:me=umh:bframes=3"
            x264enc1=x264enc+vbv
            x264enc2=x264enc1
    if is2pass == 1:
        pas1exe = "mencoder \'" + pin + "\' -vfm ffmpeg -quiet -nosound -sws 9 -ovc x264 " + encvf +" "+fps+" "+ofps+" -x264encopts " + bitrate +x264enc1+ ":threads=auto:level_idc=41:pass=1:turbo=2 -passlogfile \'" + pin + ".log\' " + " -o /dev/null"
        pas2exe = "mencoder \'" + pin + "\' -vfm ffmpeg -quiet -sws 9 -ovc x264 " + encvf +" "+fps+ " "+ofps+" -x264encopts " + bitrate +x264enc2+ ":level_idc=41:threads=auto:pass=2 -passlogfile \'" + pin + ".log\' -oac mp3lame -lameopts cbr:br=256 -o \'" + pout + "\'"
        pas1exe = "nice -n 19 " + pas1exe
        pas2exe = "nice -n 19 " + pas2exe
        recdblist.printutf8(pas1exe)
        txt=txt+"Cmd : "+pas1exe+"\n"
        txtt=""
        try:
            txtt=unicode(commands.getoutput(pas1exe.encode('utf-8')),'utf-8')
        except:
            ""
        txt=txt+txtt
        recdblist.printutf8(pas2exe)
        time.sleep(5)
        txtt=""
        try:
            txtt=unicode(commands.getoutput(pas2exe.encode('utf-8')),'utf-8')
        except:
            ""
        txt=txt+txtt
    else:
        pas1exe = "mencoder \'" + pin + "\' -vfm ffmpeg -quiet -sws 9 -ovc x264 " + encvf+" "+fps + " "+ofps+" -x264encopts " + bitrate +x264enc+":level_idc=41:threads=auto -oac mp3lame -lameopts cbr:br=256 -o \'" + pout + "\'"
        pas1exe = "nice -n 19 " + pas1exe
        recdblist.printutf8(pas1exe)
        txt=txt+"Cmd : "+pas1exe+"\n"
        txtt=""
        try:
            txtt=unicode(commands.getoutput(pas1exe.encode('utf-8')),'utf-8')
        except:
            ""
        txt=txt+txtt
    recdblist.addlog( pin, txt, "mencoder-log")

def encode_ffmpeg(pin,pout,size,is2pass,is24fps,quality):
    """
    
    """
    ffmpeg="ffmpeg"
    if quality<3:
        x264enc="-level 42 -me_method dia -partitions none -refs 1 -scenecut 0 -trellis 0 "
        x264enc1=x264enc
        x264enc2=x264enc1
    elif quality<5:
        x264enc="-level 42 -me_method dia -partitions parti8x8+parti4x4 -refs 1 -trellis 0 "
        x264enc1="-level 42 -me_method dia -partitions none -refs 1 -trellis 0 "
        x264enc1=x264enc
        x264enc2=x264enc
    elif quality<7:
        x264enc="-level 42 "
        x264enc1="-level 42 -me_method dia -partitions none "
        x264enc1=x264enc
        x264enc2=x264enc
    elif quality<9:
        x264enc="-level 42 -directpred auto -refs 5 -subq 6 -bf 1 -trellis 1 "
        x264enc1="-level 42 -me_method dia -partitions none -refs 1 -subq 6 -bf 1 -trellis 1 "
        x264enc1=x264enc
        x264enc2=x264enc
    elif quality<11:
        x264enc="-level 42 -refs 5 -subq 7 -trellis 2 -partitions all -directpred auto -me_method umh -bf 3 "
        x264enc1="-level 42 -me_method dia -partitions none -refs 1 -subq 7 -trellis 2 -directpred auto -bf 3 "
        x264enc1=x264enc
        x264enc2=x264enc
    if is24fps==1:
        if quality<3:
            x264enc="-level 42 -me_method dia -partitions none -refs 1 -scenecut 0 -trellis 0 -deblockalpha 1 -deblockbeta 1 "
            x264enc1="-level 42 -me_method dia -partitions none -refs 1 -scenecut 0 -trellis 0 -deblockalpha 1 -deblockbeta 1 "
            x264enc1=x264enc
            x264enc2=x264enc
        elif quality<5:
            x264enc="-level 42 -me_method dia -partitions parti8x8+parti4x4 -refs 1 -trellis 0 -deblockalpha 1 -deblockbeta 1 "
            x264enc1="-level 42 -me_method dia -partitions none -refs 1 -trellis 0 -deblockalpha 1 -deblockbeta 1 "
            x264enc1=x264enc
            x264enc2=x264enc
        elif quality<7:
            x264enc="-level 42 -deblockalpha 1 -deblockbeta 1 "
            x264enc1="-me_method dia -partitions none -vpre hq -level 42 -deblockalpha 1 -deblockbeta 1 "
            x264enc1=x264enc
            x264enc2=x264enc
        elif quality<9:
            x264enc="-level 42 -directpred auto -refs 5 -subq 6 -bf 1 -trellis 1 -deblockalpha 1 -deblockbeta 1 "
            x264enc1="-level 42 -directpred auto -me_method dia -partitions none -refs 1 -subq 6 -bf 1 -trellis 1 -deblockalpha 1 -deblockbeta 1 "
            x264enc1=x264enc
            x264enc2=x264enc
        elif quality<11:
            x264enc="-level 42 -refs 5 -subq 7 -trellis 2 -partitions all -directpred auto -me_method umh -bf 3 -deblockalpha 1 -deblockbeta 1 "
            x264enc1="-level 42 -refs 1 -subq 7 -trellis 2 -partitions none -directpred auto -me_method dia -bf 3 -deblockalpha 1 -deblockbeta 1 "
            x264enc1=x264enc
            x264enc2=x264enc
    if size == "HD":
        s = "-s 1280x720 "
        bitrate = str(tv2avi.Bitrate_HD)
        crf="crf=20"
    elif size == "SD":
        s ="-s 720x480 "
        bitrate = str(tv2avi.Bitrate_SD)
        crf="crf=20"
    elif size == "FHD":
        s ="-s 1920x1080 "
        bitrate = str(tv2avi.Bitrate_FHD)
        crf="crf=22"
    elif size == "Short":
        s= ""
        bitrate = str(tv2avi.Bitrate_Short)
        crf="crf=20"
    elif size == "LowHD":
        s = "-s 1280x720 "
        bitrate = str(tv2avi.Bitrate_LowHD)
        crf="crf=22"
    else:
        s = "-s 1280x720 "
        bitrate = str(tv2avi.Bitrate_LowHD)
        crf="crf=22"
    txt=""
    if is2pass==1:
        os.environ['LANG']="ja_JP.UTF-8"
        exe1=ffmpeg+" -y -i \""+pin+"\" -pass 1 -vsync 400 -vcodec libx264 -vpre fastfirstpass -b "+bitrate+"k "+x264enc1+s+"-deinterlace -an -f avi /dev/null"
        exe2=ffmpeg+" -y -i \""+pin+"\" -pass 2 -vsync 400 -vcodec libx264 -vpre hq -b "+bitrate+"k "+x264enc2+s+"-deinterlace -an -f avi \"" +pout+"\"" #aviにすべきかどうか
        recdblist.printutf8(exe1)
        exe1 = "nice -n 19 " + exe1
        exe2 = "nice -n 19 " + exe2
        txt=txt+u"Cmd : "+exe1+"\n"
        txtt=""
        try:
            txtt=unicode(commands.getoutput(exe1.encode('utf-8')),'utf-8')
        except:
            ""
        txt=txt+txtt
        recdblist.addlog( pin, txt, "dual audio ffmpeg-log - 1pass")
        txt=""
        txt=txt+u"Cmd : "+exe2+"\n"
        txtt=""
        try:
            txtt=unicode(commands.getoutput(exe2.encode('utf-8')),'utf-8')
        except:
            ""
        txt=txt+txtt
        recdblist.addlog( pin, txt, "dual audio ffmpeg-log - 2pass")
    else:
        os.environ['LANG']="ja_JP.UTF-8"
        exe=ffmpeg+" -y -i \""+pin+"\" -vsync 400 -vcodec libx264 -vpre hq -b "+bitrate+"k "+x264enc+s+"-deinterlace -an \"" +pout+"\""
        txt=txt+"Cmd : "+exe+"\n"
        exe = "nice -n 19 " + exe
        txt=txt+"Cmd : "+exe+"\n"
        txtt=""
        try:
            txtt=unicode(commands.getoutput(exe.encode('utf-8')),'utf-8')
        except:
            ""
        txt=txt+txtt
        recdblist.addlog( pin, txt, "dual audio ffmpeg-log")
    